import React, {Suspense, useEffect, useState} from 'react';
import {Tour} from './types';
import {Spin, Typography} from 'antd';
import TourList from "./components/TourList.tsx";

const { Title } = Typography;

const fetchTours = async (): Promise<Tour[]> => {
    const response = await fetch('https://jsonplaceholder.typicode.com/posts');
    return await response.json();
};

const App: React.FC = () => {
    const [tours, setTours] = useState<Tour[]>([]);
    const [loading, setLoading] = useState<boolean>(false);

    useEffect(() => {
        console.log("in use effect");
        setLoading(true);
        fetchTours().then(data => {
            setTours(data);
            setLoading(false);
        });
    }, []);

    const handleReserve = (tour: Tour) => {
        alert(`Резервирана екскурзия: ${tour.title}`);
    };

    return (
        <div style={{ padding: '20px' }}>
            <Title level={2}>Нашите Екскурзии</Title>
            <React.Fragment>
                <Suspense fallback={<Spin size="large" />}>
                    <React.Profiler id="tour-list" onRender={(id, phase, actualDuration) => {
                        console.log(`${id} е рендериран по време на фазата ${phase}`);
                        console.log(`Рендериране на компонента отне ${actualDuration}ms`);
                    }}>
                        <TourList tours={tours} loading={loading} onReserve={handleReserve} />
                    </React.Profiler>
                </Suspense>
            </React.Fragment>
        </div>
    );
};


export default App;
